/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.PersistentVolume;
import io.fabric8.kubernetes.api.model.v4_4.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.v4_4.PersistentVolumeFluentImpl;
import javax.validation.Validator;

public class PersistentVolumeBuilder
extends PersistentVolumeFluentImpl<PersistentVolumeBuilder>
implements VisitableBuilder<PersistentVolume, PersistentVolumeBuilder> {
    PersistentVolumeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PersistentVolumeBuilder() {
        this(true);
    }

    public PersistentVolumeBuilder(Boolean validationEnabled) {
        this(new PersistentVolume(), validationEnabled);
    }

    public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PersistentVolume(), validationEnabled);
    }

    public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent, PersistentVolume instance) {
        this(fluent, instance, true);
    }

    public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent, PersistentVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PersistentVolumeBuilder(PersistentVolume instance) {
        this(instance, (Boolean)true);
    }

    public PersistentVolumeBuilder(PersistentVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PersistentVolumeBuilder(Validator validator) {
        this(new PersistentVolume(), (Boolean)true);
    }

    public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent, PersistentVolume instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PersistentVolumeBuilder(PersistentVolume instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PersistentVolume build() {
        PersistentVolume buildable = new PersistentVolume(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeBuilder that = (PersistentVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

