/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.OwnerReference;
import io.fabric8.kubernetes.api.model.v4_4.OwnerReferenceFluent;
import io.fabric8.kubernetes.api.model.v4_4.OwnerReferenceFluentImpl;
import javax.validation.Validator;

public class OwnerReferenceBuilder
extends OwnerReferenceFluentImpl<OwnerReferenceBuilder>
implements VisitableBuilder<OwnerReference, OwnerReferenceBuilder> {
    OwnerReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OwnerReferenceBuilder() {
        this(true);
    }

    public OwnerReferenceBuilder(Boolean validationEnabled) {
        this(new OwnerReference(), validationEnabled);
    }

    public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OwnerReference(), validationEnabled);
    }

    public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent, OwnerReference instance) {
        this(fluent, instance, true);
    }

    public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent, OwnerReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
        fluent.withController(instance.getController());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public OwnerReferenceBuilder(OwnerReference instance) {
        this(instance, (Boolean)true);
    }

    public OwnerReferenceBuilder(OwnerReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
        this.withController(instance.getController());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public OwnerReferenceBuilder(Validator validator) {
        this(new OwnerReference(), (Boolean)true);
    }

    public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent, OwnerReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
        fluent.withController(instance.getController());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public OwnerReferenceBuilder(OwnerReference instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
        this.withController(instance.getController());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public OwnerReference build() {
        OwnerReference buildable = new OwnerReference(this.fluent.getApiVersion(), this.fluent.isBlockOwnerDeletion(), this.fluent.isController(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getUid());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OwnerReferenceBuilder that = (OwnerReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

