/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.MicroTime;
import io.fabric8.kubernetes.api.model.v4_4.MicroTimeFluent;
import io.fabric8.kubernetes.api.model.v4_4.MicroTimeFluentImpl;
import javax.validation.Validator;

public class MicroTimeBuilder
extends MicroTimeFluentImpl<MicroTimeBuilder>
implements VisitableBuilder<MicroTime, MicroTimeBuilder> {
    MicroTimeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MicroTimeBuilder() {
        this(true);
    }

    public MicroTimeBuilder(Boolean validationEnabled) {
        this(new MicroTime(), validationEnabled);
    }

    public MicroTimeBuilder(MicroTimeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MicroTimeBuilder(MicroTimeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MicroTime(), validationEnabled);
    }

    public MicroTimeBuilder(MicroTimeFluent<?> fluent, MicroTime instance) {
        this(fluent, instance, true);
    }

    public MicroTimeBuilder(MicroTimeFluent<?> fluent, MicroTime instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTime(instance.getTime());
        this.validationEnabled = validationEnabled;
    }

    public MicroTimeBuilder(MicroTime instance) {
        this(instance, (Boolean)true);
    }

    public MicroTimeBuilder(MicroTime instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTime(instance.getTime());
        this.validationEnabled = validationEnabled;
    }

    public MicroTimeBuilder(Validator validator) {
        this(new MicroTime(), (Boolean)true);
    }

    public MicroTimeBuilder(MicroTimeFluent<?> fluent, MicroTime instance, Validator validator) {
        this.fluent = fluent;
        fluent.withTime(instance.getTime());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public MicroTimeBuilder(MicroTime instance, Validator validator) {
        this.fluent = this;
        this.withTime(instance.getTime());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public MicroTime build() {
        MicroTime buildable = new MicroTime(this.fluent.getTime());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MicroTimeBuilder that = (MicroTimeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

