/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_4.Nested;
import io.fabric8.kubernetes.api.model.v4_4.EndpointAddress;
import io.fabric8.kubernetes.api.model.v4_4.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.v4_4.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_4.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_4.ObjectReferenceFluentImpl;

public class EndpointAddressFluentImpl<A extends EndpointAddressFluent<A>>
extends BaseFluent<A>
implements EndpointAddressFluent<A> {
    private String hostname;
    private String ip;
    private String nodeName;
    private ObjectReferenceBuilder targetRef;

    public EndpointAddressFluentImpl() {
    }

    public EndpointAddressFluentImpl(EndpointAddress instance) {
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A withNewHostname(String arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuilder arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuffer arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public A withNewIp(String arg1) {
        return this.withIp(new String(arg1));
    }

    @Override
    public A withNewIp(StringBuilder arg1) {
        return this.withIp(new String(arg1));
    }

    @Override
    public A withNewIp(StringBuffer arg1) {
        return this.withIp(new String(arg1));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public A withNewNodeName(String arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuilder arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuffer arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(ObjectReference targetRef) {
        this._visitables.get("targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressFluentImpl that = (EndpointAddressFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        return !(this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null);
    }

    public class TargetRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<EndpointAddressFluent.TargetRefNested<N>>
    implements EndpointAddressFluent.TargetRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        TargetRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TargetRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointAddressFluentImpl.this.withTargetRef(this.builder.build());
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }
    }
}

