/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_4.Nested;
import io.fabric8.kubernetes.api.model.v4_4.ContainerState;
import io.fabric8.kubernetes.api.model.v4_4.ContainerStateBuilder;
import io.fabric8.kubernetes.api.model.v4_4.ContainerStateFluentImpl;
import io.fabric8.kubernetes.api.model.v4_4.ContainerStatus;
import io.fabric8.kubernetes.api.model.v4_4.ContainerStatusFluent;

public class ContainerStatusFluentImpl<A extends ContainerStatusFluent<A>>
extends BaseFluent<A>
implements ContainerStatusFluent<A> {
    private String containerID;
    private String image;
    private String imageID;
    private ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private Integer restartCount;
    private ContainerStateBuilder state;

    public ContainerStatusFluentImpl() {
    }

    public ContainerStatusFluentImpl(ContainerStatus instance) {
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withState(instance.getState());
    }

    @Override
    public String getContainerID() {
        return this.containerID;
    }

    @Override
    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    @Override
    public Boolean hasContainerID() {
        return this.containerID != null;
    }

    @Override
    public A withNewContainerID(String arg1) {
        return this.withContainerID(new String(arg1));
    }

    @Override
    public A withNewContainerID(StringBuilder arg1) {
        return this.withContainerID(new String(arg1));
    }

    @Override
    public A withNewContainerID(StringBuffer arg1) {
        return this.withContainerID(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    @Override
    public Boolean hasImageID() {
        return this.imageID != null;
    }

    @Override
    public A withNewImageID(String arg1) {
        return this.withImageID(new String(arg1));
    }

    @Override
    public A withNewImageID(StringBuilder arg1) {
        return this.withImageID(new String(arg1));
    }

    @Override
    public A withNewImageID(StringBuffer arg1) {
        return this.withImageID(new String(arg1));
    }

    @Override
    @Deprecated
    public ContainerState getLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public A withLastState(ContainerState lastState) {
        this._visitables.get("lastState").remove(this.lastState);
        if (lastState != null) {
            this.lastState = new ContainerStateBuilder(lastState);
            this._visitables.get("lastState").add(this.lastState);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastState() {
        return this.lastState != null;
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> withNewLastState() {
        return new LastStateNestedImpl();
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item) {
        return new LastStateNestedImpl(item);
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(this.getLastState());
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : new ContainerStateBuilder().build());
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(ContainerState item) {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public Boolean isReady() {
        return this.ready;
    }

    @Override
    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Boolean hasReady() {
        return this.ready != null;
    }

    @Override
    public A withNewReady(String arg1) {
        return this.withReady(new Boolean(arg1));
    }

    @Override
    public A withNewReady(boolean arg1) {
        return this.withReady(new Boolean(arg1));
    }

    @Override
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @Override
    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)this;
    }

    @Override
    public Boolean hasRestartCount() {
        return this.restartCount != null;
    }

    @Override
    @Deprecated
    public ContainerState getState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public A withState(ContainerState state) {
        this._visitables.get("state").remove(this.state);
        if (state != null) {
            this.state = new ContainerStateBuilder(state);
            this._visitables.get("state").add(this.state);
        }
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    public ContainerStatusFluent.StateNested<A> withNewState() {
        return new StateNestedImpl();
    }

    @Override
    public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item) {
        return new StateNestedImpl(item);
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editState() {
        return this.withNewStateLike(this.getState());
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editOrNewState() {
        return this.withNewStateLike(this.getState() != null ? this.getState() : new ContainerStateBuilder().build());
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editOrNewStateLike(ContainerState item) {
        return this.withNewStateLike(this.getState() != null ? this.getState() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusFluentImpl that = (ContainerStatusFluentImpl)o;
        if (this.containerID != null ? !this.containerID.equals(that.containerID) : that.containerID != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageID != null ? !this.imageID.equals(that.imageID) : that.imageID != null) {
            return false;
        }
        if (this.lastState != null ? !this.lastState.equals(that.lastState) : that.lastState != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ready != null ? !this.ready.equals(that.ready) : that.ready != null) {
            return false;
        }
        if (this.restartCount != null ? !this.restartCount.equals(that.restartCount) : that.restartCount != null) {
            return false;
        }
        return !(this.state != null ? !this.state.equals(that.state) : that.state != null);
    }

    public class StateNestedImpl<N>
    extends ContainerStateFluentImpl<ContainerStatusFluent.StateNested<N>>
    implements ContainerStatusFluent.StateNested<N>,
    Nested<N> {
        private final ContainerStateBuilder builder;

        StateNestedImpl(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        StateNestedImpl() {
            this.builder = new ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStatusFluentImpl.this.withState(this.builder.build());
        }

        @Override
        public N endState() {
            return this.and();
        }
    }

    public class LastStateNestedImpl<N>
    extends ContainerStateFluentImpl<ContainerStatusFluent.LastStateNested<N>>
    implements ContainerStatusFluent.LastStateNested<N>,
    Nested<N> {
        private final ContainerStateBuilder builder;

        LastStateNestedImpl(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        LastStateNestedImpl() {
            this.builder = new ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStatusFluentImpl.this.withLastState(this.builder.build());
        }

        @Override
        public N endLastState() {
            return this.and();
        }
    }
}

