/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admission;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import io.fabric8.kubernetes.api.model.GroupVersionResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.authentication.UserInfo;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "dryRun", "name", "namespace", "object", "oldObject", "operation", "resource", "subResource", "uid", "userInfo"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class AdmissionRequest
implements KubernetesResource {
    @JsonProperty(value="dryRun")
    private Boolean dryRun;
    @JsonProperty(value="kind")
    @Valid
    private GroupVersionKind kind;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="object")
    @Valid
    private HasMetadata object;
    @JsonProperty(value="oldObject")
    @Valid
    private HasMetadata oldObject;
    @JsonProperty(value="operation")
    private String operation;
    @JsonProperty(value="resource")
    @Valid
    private GroupVersionResource resource;
    @JsonProperty(value="subResource")
    private String subResource;
    @JsonProperty(value="uid")
    private String uid;
    @JsonProperty(value="userInfo")
    @Valid
    private UserInfo userInfo;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public AdmissionRequest() {
    }

    public AdmissionRequest(Boolean dryRun, GroupVersionKind kind, String name, String namespace, HasMetadata object, HasMetadata oldObject, String operation, GroupVersionResource resource, String subResource, String uid, UserInfo userInfo) {
        this.dryRun = dryRun;
        this.kind = kind;
        this.name = name;
        this.namespace = namespace;
        this.object = object;
        this.oldObject = oldObject;
        this.operation = operation;
        this.resource = resource;
        this.subResource = subResource;
        this.uid = uid;
        this.userInfo = userInfo;
    }

    @JsonProperty(value="dryRun")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @JsonProperty(value="dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    @JsonProperty(value="kind")
    public GroupVersionKind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(GroupVersionKind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="object")
    public HasMetadata getObject() {
        return this.object;
    }

    @JsonProperty(value="object")
    public void setObject(HasMetadata object) {
        this.object = object;
    }

    @JsonProperty(value="oldObject")
    public HasMetadata getOldObject() {
        return this.oldObject;
    }

    @JsonProperty(value="oldObject")
    public void setOldObject(HasMetadata oldObject) {
        this.oldObject = oldObject;
    }

    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(String operation) {
        this.operation = operation;
    }

    @JsonProperty(value="resource")
    public GroupVersionResource getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    public void setResource(GroupVersionResource resource) {
        this.resource = resource;
    }

    @JsonProperty(value="subResource")
    public String getSubResource() {
        return this.subResource;
    }

    @JsonProperty(value="subResource")
    public void setSubResource(String subResource) {
        this.subResource = subResource;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="userInfo")
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @JsonProperty(value="userInfo")
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "AdmissionRequest(dryRun=" + this.getDryRun() + ", kind=" + this.getKind() + ", name=" + this.getName() + ", namespace=" + this.getNamespace() + ", object=" + this.getObject() + ", oldObject=" + this.getOldObject() + ", operation=" + this.getOperation() + ", resource=" + this.getResource() + ", subResource=" + this.getSubResource() + ", uid=" + this.getUid() + ", userInfo=" + this.getUserInfo() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdmissionRequest)) {
            return false;
        }
        AdmissionRequest other = (AdmissionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$dryRun = this.getDryRun();
        Boolean other$dryRun = other.getDryRun();
        if (this$dryRun == null ? other$dryRun != null : !((Object)this$dryRun).equals(other$dryRun)) {
            return false;
        }
        GroupVersionKind this$kind = this.getKind();
        GroupVersionKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        HasMetadata this$object = this.getObject();
        HasMetadata other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        HasMetadata this$oldObject = this.getOldObject();
        HasMetadata other$oldObject = other.getOldObject();
        if (this$oldObject == null ? other$oldObject != null : !this$oldObject.equals(other$oldObject)) {
            return false;
        }
        String this$operation = this.getOperation();
        String other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        GroupVersionResource this$resource = this.getResource();
        GroupVersionResource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        String this$subResource = this.getSubResource();
        String other$subResource = other.getSubResource();
        if (this$subResource == null ? other$subResource != null : !this$subResource.equals(other$subResource)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        UserInfo this$userInfo = this.getUserInfo();
        UserInfo other$userInfo = other.getUserInfo();
        if (this$userInfo == null ? other$userInfo != null : !((Object)this$userInfo).equals(other$userInfo)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdmissionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $dryRun = this.getDryRun();
        result = result * 59 + ($dryRun == null ? 43 : ((Object)$dryRun).hashCode());
        GroupVersionKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        HasMetadata $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        HasMetadata $oldObject = this.getOldObject();
        result = result * 59 + ($oldObject == null ? 43 : $oldObject.hashCode());
        String $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        GroupVersionResource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        String $subResource = this.getSubResource();
        result = result * 59 + ($subResource == null ? 43 : $subResource.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        UserInfo $userInfo = this.getUserInfo();
        result = result * 59 + ($userInfo == null ? 43 : ((Object)$userInfo).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

