/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_4.handlers;

import io.fabric8.kubernetes.clnt.v4_4.Config;
import io.fabric8.kubernetes.clnt.v4_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_4.Watch;
import io.fabric8.kubernetes.clnt.v4_4.Watcher;
import io.fabric8.kubernetes.clnt.v4_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_4.dsl.Resource;
import io.fabric8.openshift.api.model.v4_4.OAuthClient;
import io.fabric8.openshift.api.model.v4_4.OAuthClientBuilder;
import io.fabric8.openshift.clnt.v4_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_4.dsl.internal.OAuthClientOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthClientHandler
implements ResourceHandler<OAuthClient, OAuthClientBuilder> {
    @Override
    public String getKind() {
        return OAuthClient.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public OAuthClient create(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new OAuthClient[0]);
    }

    @Override
    public OAuthClient replace(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public OAuthClient reload(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)((Gettable)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public OAuthClientBuilder edit(OAuthClient item) {
        return new OAuthClientBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, OAuthClient item) {
        if (cascading.booleanValue()) {
            return (Boolean)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, Watcher<OAuthClient> watcher) {
        return (Watch)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, String resourceVersion, Watcher<OAuthClient> watcher) {
        return (Watch)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public OAuthClient waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthClient item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public OAuthClient waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthClient item, Predicate<OAuthClient> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

