/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_4.handlers;

import io.fabric8.kubernetes.clnt.v4_4.Config;
import io.fabric8.kubernetes.clnt.v4_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_4.Watch;
import io.fabric8.kubernetes.clnt.v4_4.Watcher;
import io.fabric8.kubernetes.clnt.v4_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_4.dsl.Resource;
import io.fabric8.openshift.api.model.v4_4.Image;
import io.fabric8.openshift.api.model.v4_4.ImageBuilder;
import io.fabric8.openshift.clnt.v4_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_4.dsl.internal.ImageOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageHandler
implements ResourceHandler<Image, ImageBuilder> {
    @Override
    public String getKind() {
        return Image.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public Image create(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Image[0]);
    }

    @Override
    public Image replace(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Image reload(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Gettable)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageBuilder edit(Image item) {
        return new ImageBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Image item) {
        if (cascading.booleanValue()) {
            return (Boolean)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, String resourceVersion, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Image waitUntilReady(OkHttpClient client, Config config, String namespace, Image item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Image waitUntilCondition(OkHttpClient client, Config config, String namespace, Image item, Predicate<Image> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

