/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_4.TagEvent;
import io.fabric8.openshift.api.model.v4_4.TagEventFluent;
import io.fabric8.openshift.api.model.v4_4.TagEventFluentImpl;
import javax.validation.Validator;

public class TagEventBuilder
extends TagEventFluentImpl<TagEventBuilder>
implements VisitableBuilder<TagEvent, TagEventBuilder> {
    TagEventFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TagEventBuilder() {
        this(true);
    }

    public TagEventBuilder(Boolean validationEnabled) {
        this(new TagEvent(), validationEnabled);
    }

    public TagEventBuilder(TagEventFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TagEvent(), validationEnabled);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, TagEvent instance) {
        this(fluent, instance, true);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, TagEvent instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCreated(instance.getCreated());
        fluent.withDockerImageReference(instance.getDockerImageReference());
        fluent.withGeneration(instance.getGeneration());
        fluent.withImage(instance.getImage());
        this.validationEnabled = validationEnabled;
    }

    public TagEventBuilder(TagEvent instance) {
        this(instance, (Boolean)true);
    }

    public TagEventBuilder(TagEvent instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCreated(instance.getCreated());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withGeneration(instance.getGeneration());
        this.withImage(instance.getImage());
        this.validationEnabled = validationEnabled;
    }

    public TagEventBuilder(Validator validator) {
        this(new TagEvent(), (Boolean)true);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, TagEvent instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCreated(instance.getCreated());
        fluent.withDockerImageReference(instance.getDockerImageReference());
        fluent.withGeneration(instance.getGeneration());
        fluent.withImage(instance.getImage());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TagEventBuilder(TagEvent instance, Validator validator) {
        this.fluent = this;
        this.withCreated(instance.getCreated());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withGeneration(instance.getGeneration());
        this.withImage(instance.getImage());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public TagEvent build() {
        TagEvent buildable = new TagEvent(this.fluent.getCreated(), this.fluent.getDockerImageReference(), this.fluent.getGeneration(), this.fluent.getImage());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagEventBuilder that = (TagEventBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

