/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_4.RouteSpec;
import io.fabric8.openshift.api.model.v4_4.RouteSpecFluent;
import io.fabric8.openshift.api.model.v4_4.RouteSpecFluentImpl;
import javax.validation.Validator;

public class RouteSpecBuilder
extends RouteSpecFluentImpl<RouteSpecBuilder>
implements VisitableBuilder<RouteSpec, RouteSpecBuilder> {
    RouteSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RouteSpecBuilder() {
        this(true);
    }

    public RouteSpecBuilder(Boolean validationEnabled) {
        this(new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance) {
        this(fluent, instance, true);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAlternateBackends(instance.getAlternateBackends());
        fluent.withHost(instance.getHost());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withTls(instance.getTls());
        fluent.withTo(instance.getTo());
        fluent.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    public RouteSpecBuilder(RouteSpec instance) {
        this(instance, (Boolean)true);
    }

    public RouteSpecBuilder(RouteSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    public RouteSpecBuilder(Validator validator) {
        this(new RouteSpec(), (Boolean)true);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAlternateBackends(instance.getAlternateBackends());
        fluent.withHost(instance.getHost());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withTls(instance.getTls());
        fluent.withTo(instance.getTo());
        fluent.withWildcardPolicy(instance.getWildcardPolicy());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RouteSpecBuilder(RouteSpec instance, Validator validator) {
        this.fluent = this;
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RouteSpec build() {
        RouteSpec buildable = new RouteSpec(this.fluent.getAlternateBackends(), this.fluent.getHost(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getTls(), this.fluent.getTo(), this.fluent.getWildcardPolicy());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecBuilder that = (RouteSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

