/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_4.RouteList;
import io.fabric8.openshift.api.model.v4_4.RouteListFluent;
import io.fabric8.openshift.api.model.v4_4.RouteListFluentImpl;
import javax.validation.Validator;

public class RouteListBuilder
extends RouteListFluentImpl<RouteListBuilder>
implements VisitableBuilder<RouteList, RouteListBuilder> {
    RouteListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RouteListBuilder() {
        this(true);
    }

    public RouteListBuilder(Boolean validationEnabled) {
        this(new RouteList(), validationEnabled);
    }

    public RouteListBuilder(RouteListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteListBuilder(RouteListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteList(), validationEnabled);
    }

    public RouteListBuilder(RouteListFluent<?> fluent, RouteList instance) {
        this(fluent, instance, true);
    }

    public RouteListBuilder(RouteListFluent<?> fluent, RouteList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public RouteListBuilder(RouteList instance) {
        this(instance, (Boolean)true);
    }

    public RouteListBuilder(RouteList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public RouteListBuilder(Validator validator) {
        this(new RouteList(), (Boolean)true);
    }

    public RouteListBuilder(RouteListFluent<?> fluent, RouteList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RouteListBuilder(RouteList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RouteList build() {
        RouteList buildable = new RouteList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteListBuilder that = (RouteListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

