/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.clnt.v4_4.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_4.RequestConfigFluent;
import io.fabric8.kubernetes.clnt.v4_4.RequestConfigFluentImpl;

public class RequestConfigBuilder
extends RequestConfigFluentImpl<RequestConfigBuilder>
implements VisitableBuilder<RequestConfig, RequestConfigBuilder> {
    RequestConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RequestConfigBuilder() {
        this(true);
    }

    public RequestConfigBuilder(Boolean validationEnabled) {
        this(new RequestConfig(), validationEnabled);
    }

    public RequestConfigBuilder(RequestConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RequestConfigBuilder(RequestConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RequestConfig(), validationEnabled);
    }

    public RequestConfigBuilder(RequestConfigFluent<?> fluent, RequestConfig instance) {
        this(fluent, instance, true);
    }

    public RequestConfigBuilder(RequestConfigFluent<?> fluent, RequestConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withUsername(instance.getUsername());
        fluent.withPassword(instance.getPassword());
        fluent.withOauthToken(instance.getOauthToken());
        fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        fluent.withConnectionTimeout(instance.getConnectionTimeout());
        fluent.withRollingTimeout(instance.getRollingTimeout());
        fluent.withRequestTimeout(instance.getRequestTimeout());
        fluent.withScaleTimeout(instance.getScaleTimeout());
        fluent.withLoggingInterval(instance.getLoggingInterval());
        fluent.withWebsocketTimeout(instance.getWebsocketTimeout());
        fluent.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        fluent.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        fluent.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        fluent.withOauthTokenProvider(instance.getOauthTokenProvider());
        fluent.withImpersonateUsername(instance.getImpersonateUsername());
        fluent.withImpersonateGroups(instance.getImpersonateGroups());
        fluent.withImpersonateExtras(instance.getImpersonateExtras());
        this.validationEnabled = validationEnabled;
    }

    public RequestConfigBuilder(RequestConfig instance) {
        this(instance, (Boolean)true);
    }

    public RequestConfigBuilder(RequestConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withUsername(instance.getUsername());
        this.withPassword(instance.getPassword());
        this.withOauthToken(instance.getOauthToken());
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withConnectionTimeout(instance.getConnectionTimeout());
        this.withRollingTimeout(instance.getRollingTimeout());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        this.withOauthTokenProvider(instance.getOauthTokenProvider());
        this.withImpersonateUsername(instance.getImpersonateUsername());
        this.withImpersonateGroups(instance.getImpersonateGroups());
        this.withImpersonateExtras(instance.getImpersonateExtras());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RequestConfig build() {
        RequestConfig buildable = new RequestConfig(this.fluent.getUsername(), this.fluent.getPassword(), this.fluent.getOauthToken(), this.fluent.getWatchReconnectLimit(), this.fluent.getWatchReconnectInterval(), this.fluent.getConnectionTimeout(), this.fluent.getRollingTimeout(), this.fluent.getRequestTimeout(), this.fluent.getScaleTimeout(), this.fluent.getLoggingInterval(), this.fluent.getWebsocketTimeout(), this.fluent.getWebsocketPingInterval(), this.fluent.getMaxConcurrentRequests(), this.fluent.getMaxConcurrentRequestsPerHost(), this.fluent.getOauthTokenProvider());
        buildable.setImpersonateUsername(this.fluent.getImpersonateUsername());
        buildable.setImpersonateGroups(this.fluent.getImpersonateGroups());
        buildable.setImpersonateExtras(this.fluent.getImpersonateExtras());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestConfigBuilder that = (RequestConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

