/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_4;

import io.fabric8.kubernetes.api.model.v4_4.RootPaths;
import io.fabric8.kubernetes.clnt.v4_4.Adapters;
import io.fabric8.kubernetes.clnt.v4_4.Client;
import io.fabric8.kubernetes.clnt.v4_4.Config;
import io.fabric8.kubernetes.clnt.v4_4.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_4.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v4_4.HttpClientAware;
import io.fabric8.kubernetes.clnt.v4_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_4.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v4_4.utils.Utils;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
implements Client,
HttpClientAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseClient.class);
    protected OkHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public BaseClient(String masterUrl) throws KubernetesClientException {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public BaseClient(Config config) throws KubernetesClientException {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(OkHttpClient httpClient, Config config) throws KubernetesClientException {
        try {
            this.httpClient = httpClient;
            this.namespace = config.getNamespace();
            this.configuration = config;
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void close() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        Utils.shutdownExecutorService(executorService);
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new BaseOperation(new OperationContext().withOkhttpClient(this.httpClient).withConfig(this.configuration)){}.getRootPaths();
    }

    @Override
    public boolean supportsApiPath(String apiPath) {
        List<String> paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }
}

