/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4.rbac;

import io.fabric8.kubernetes.api.builder.v4_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_4.Nested;
import io.fabric8.kubernetes.api.builder.v4_4.Predicate;
import io.fabric8.kubernetes.api.model.v4_4.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_4.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_4.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_4.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.v4_4.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.v4_4.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.v4_4.rbac.RoleRefBuilder;
import io.fabric8.kubernetes.api.model.v4_4.rbac.RoleRefFluentImpl;
import io.fabric8.kubernetes.api.model.v4_4.rbac.Subject;
import io.fabric8.kubernetes.api.model.v4_4.rbac.SubjectBuilder;
import io.fabric8.kubernetes.api.model.v4_4.rbac.SubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RoleBindingFluentImpl<A extends RoleBindingFluent<A>>
extends BaseFluent<A>
implements RoleBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private RoleRefBuilder roleRef;
    private List<SubjectBuilder> subjects;

    public RoleBindingFluentImpl() {
    }

    public RoleBindingFluentImpl(RoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public RoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(RoleRef roleRef) {
        this._visitables.get("roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new RoleRefBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public A withNewRoleRef(String apiGroup, String kind, String name) {
        return this.withRoleRef(new RoleRef(apiGroup, kind, name));
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(RoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new RoleRefBuilder().build());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(RoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        this._visitables.get("subjects").add(index >= 0 ? index : this._visitables.get("subjects").size(), builder);
        this.subjects.add(index >= 0 ? index : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.get("subjects").size()) {
            this._visitables.get("subjects").add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(Subject ... items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<Subject> items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subject> getSubjects() {
        return RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<Subject> buildSubjects() {
        return RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<SubjectBuilder>();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new Subject(apiGroup, kind, name, namespace));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.apply(this.subjects.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingFluentImpl that = (RoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public class SubjectsNestedImpl<N>
    extends SubjectFluentImpl<RoleBindingFluent.SubjectsNested<N>>
    implements RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final SubjectBuilder builder;
        private final int index;

        SubjectsNestedImpl(int index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends RoleRefFluentImpl<RoleBindingFluent.RoleRefNested<N>>
    implements RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final RoleRefBuilder builder;

        RoleRefNestedImpl(RoleRef item) {
            this.builder = new RoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new RoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleBindingFluent.MetadataNested<N>>
    implements RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

