/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4.authorization;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.authorization.NonResourceRule;
import io.fabric8.kubernetes.api.model.v4_4.authorization.NonResourceRuleFluent;
import io.fabric8.kubernetes.api.model.v4_4.authorization.NonResourceRuleFluentImpl;
import javax.validation.Validator;

public class NonResourceRuleBuilder
extends NonResourceRuleFluentImpl<NonResourceRuleBuilder>
implements VisitableBuilder<NonResourceRule, NonResourceRuleBuilder> {
    NonResourceRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NonResourceRuleBuilder() {
        this(true);
    }

    public NonResourceRuleBuilder(Boolean validationEnabled) {
        this(new NonResourceRule(), validationEnabled);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NonResourceRule(), validationEnabled);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, NonResourceRule instance) {
        this(fluent, instance, true);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, NonResourceRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public NonResourceRuleBuilder(NonResourceRule instance) {
        this(instance, (Boolean)true);
    }

    public NonResourceRuleBuilder(NonResourceRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public NonResourceRuleBuilder(Validator validator) {
        this(new NonResourceRule(), (Boolean)true);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, NonResourceRule instance, Validator validator) {
        this.fluent = fluent;
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withVerbs(instance.getVerbs());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NonResourceRuleBuilder(NonResourceRule instance, Validator validator) {
        this.fluent = this;
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withVerbs(instance.getVerbs());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NonResourceRule build() {
        NonResourceRule buildable = new NonResourceRule(this.fluent.getNonResourceURLs(), this.fluent.getVerbs());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonResourceRuleBuilder that = (NonResourceRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

