/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4.admissionregistration;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.admissionregistration.ServiceReference;
import io.fabric8.kubernetes.api.model.v4_4.admissionregistration.ServiceReferenceFluent;
import io.fabric8.kubernetes.api.model.v4_4.admissionregistration.ServiceReferenceFluentImpl;
import javax.validation.Validator;

public class ServiceReferenceBuilder
extends ServiceReferenceFluentImpl<ServiceReferenceBuilder>
implements VisitableBuilder<ServiceReference, ServiceReferenceBuilder> {
    ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceReferenceBuilder() {
        this(true);
    }

    public ServiceReferenceBuilder(Boolean validationEnabled) {
        this(new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance) {
        this(fluent, instance, true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withPath(instance.getPath());
        this.validationEnabled = validationEnabled;
    }

    public ServiceReferenceBuilder(ServiceReference instance) {
        this(instance, (Boolean)true);
    }

    public ServiceReferenceBuilder(ServiceReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withPath(instance.getPath());
        this.validationEnabled = validationEnabled;
    }

    public ServiceReferenceBuilder(Validator validator) {
        this(new ServiceReference(), (Boolean)true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withPath(instance.getPath());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceReferenceBuilder(ServiceReference instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withPath(instance.getPath());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceReference build() {
        ServiceReference buildable = new ServiceReference(this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getPath());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceReferenceBuilder that = (ServiceReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

