/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.SecretReference;
import io.fabric8.kubernetes.api.model.v4_4.SecretReferenceFluent;
import io.fabric8.kubernetes.api.model.v4_4.SecretReferenceFluentImpl;
import javax.validation.Validator;

public class SecretReferenceBuilder
extends SecretReferenceFluentImpl<SecretReferenceBuilder>
implements VisitableBuilder<SecretReference, SecretReferenceBuilder> {
    SecretReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SecretReferenceBuilder() {
        this(true);
    }

    public SecretReferenceBuilder(Boolean validationEnabled) {
        this(new SecretReference(), validationEnabled);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretReference(), validationEnabled);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance) {
        this(fluent, instance, true);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public SecretReferenceBuilder(SecretReference instance) {
        this(instance, (Boolean)true);
    }

    public SecretReferenceBuilder(SecretReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public SecretReferenceBuilder(Validator validator) {
        this(new SecretReference(), (Boolean)true);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SecretReferenceBuilder(SecretReference instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public SecretReference build() {
        SecretReference buildable = new SecretReference(this.fluent.getName(), this.fluent.getNamespace());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretReferenceBuilder that = (SecretReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

