/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.v4_4.ReplicationControllerStatusFluent;
import io.fabric8.kubernetes.api.model.v4_4.ReplicationControllerStatusFluentImpl;
import javax.validation.Validator;

public class ReplicationControllerStatusBuilder
extends ReplicationControllerStatusFluentImpl<ReplicationControllerStatusBuilder>
implements VisitableBuilder<ReplicationControllerStatus, ReplicationControllerStatusBuilder> {
    ReplicationControllerStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ReplicationControllerStatusBuilder() {
        this(true);
    }

    public ReplicationControllerStatusBuilder(Boolean validationEnabled) {
        this(new ReplicationControllerStatus(), validationEnabled);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicationControllerStatus(), validationEnabled);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, ReplicationControllerStatus instance) {
        this(fluent, instance, true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, ReplicationControllerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withConditions(instance.getConditions());
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance) {
        this(instance, (Boolean)true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerStatusBuilder(Validator validator) {
        this(new ReplicationControllerStatus(), (Boolean)true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, ReplicationControllerStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withConditions(instance.getConditions());
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance, Validator validator) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ReplicationControllerStatus build() {
        ReplicationControllerStatus buildable = new ReplicationControllerStatus(this.fluent.getAvailableReplicas(), this.fluent.getConditions(), this.fluent.getFullyLabeledReplicas(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerStatusBuilder that = (ReplicationControllerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

