/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_4.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v4_4.ObjectMetaFluentImpl;
import javax.validation.Validator;

public class ObjectMetaBuilder
extends ObjectMetaFluentImpl<ObjectMetaBuilder>
implements VisitableBuilder<ObjectMeta, ObjectMetaBuilder> {
    ObjectMetaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ObjectMetaBuilder() {
        this(true);
    }

    public ObjectMetaBuilder(Boolean validationEnabled) {
        this(new ObjectMeta(), validationEnabled);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectMeta(), validationEnabled);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, ObjectMeta instance) {
        this(fluent, instance, true);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, ObjectMeta instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withClusterName(instance.getClusterName());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
        fluent.withFinalizers(instance.getFinalizers());
        fluent.withGenerateName(instance.getGenerateName());
        fluent.withGeneration(instance.getGeneration());
        fluent.withInitializers(instance.getInitializers());
        fluent.withLabels(instance.getLabels());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withOwnerReferences(instance.getOwnerReferences());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public ObjectMetaBuilder(ObjectMeta instance) {
        this(instance, (Boolean)true);
    }

    public ObjectMetaBuilder(ObjectMeta instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withClusterName(instance.getClusterName());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withInitializers(instance.getInitializers());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public ObjectMetaBuilder(Validator validator) {
        this(new ObjectMeta(), (Boolean)true);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, ObjectMeta instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withClusterName(instance.getClusterName());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
        fluent.withFinalizers(instance.getFinalizers());
        fluent.withGenerateName(instance.getGenerateName());
        fluent.withGeneration(instance.getGeneration());
        fluent.withInitializers(instance.getInitializers());
        fluent.withLabels(instance.getLabels());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withOwnerReferences(instance.getOwnerReferences());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ObjectMetaBuilder(ObjectMeta instance, Validator validator) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withClusterName(instance.getClusterName());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withInitializers(instance.getInitializers());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ObjectMeta build() {
        ObjectMeta buildable = new ObjectMeta(this.fluent.getAnnotations(), this.fluent.getClusterName(), this.fluent.getCreationTimestamp(), this.fluent.getDeletionGracePeriodSeconds(), this.fluent.getDeletionTimestamp(), this.fluent.getFinalizers(), this.fluent.getGenerateName(), this.fluent.getGeneration(), this.fluent.getInitializers(), this.fluent.getLabels(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getOwnerReferences(), this.fluent.getResourceVersion(), this.fluent.getSelfLink(), this.fluent.getUid());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetaBuilder that = (ObjectMetaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

