/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.GroupVersionForDiscovery;
import io.fabric8.kubernetes.api.model.v4_4.GroupVersionForDiscoveryFluent;
import io.fabric8.kubernetes.api.model.v4_4.GroupVersionForDiscoveryFluentImpl;
import javax.validation.Validator;

public class GroupVersionForDiscoveryBuilder
extends GroupVersionForDiscoveryFluentImpl<GroupVersionForDiscoveryBuilder>
implements VisitableBuilder<GroupVersionForDiscovery, GroupVersionForDiscoveryBuilder> {
    GroupVersionForDiscoveryFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GroupVersionForDiscoveryBuilder() {
        this(true);
    }

    public GroupVersionForDiscoveryBuilder(Boolean validationEnabled) {
        this(new GroupVersionForDiscovery(), validationEnabled);
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GroupVersionForDiscovery(), validationEnabled);
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent, GroupVersionForDiscovery instance) {
        this(fluent, instance, true);
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent, GroupVersionForDiscovery instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGroupVersion(instance.getGroupVersion());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance) {
        this(instance, (Boolean)true);
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGroupVersion(instance.getGroupVersion());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public GroupVersionForDiscoveryBuilder(Validator validator) {
        this(new GroupVersionForDiscovery(), (Boolean)true);
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent, GroupVersionForDiscovery instance, Validator validator) {
        this.fluent = fluent;
        fluent.withGroupVersion(instance.getGroupVersion());
        fluent.withVersion(instance.getVersion());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance, Validator validator) {
        this.fluent = this;
        this.withGroupVersion(instance.getGroupVersion());
        this.withVersion(instance.getVersion());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public GroupVersionForDiscovery build() {
        GroupVersionForDiscovery buildable = new GroupVersionForDiscovery(this.fluent.getGroupVersion(), this.fluent.getVersion());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupVersionForDiscoveryBuilder that = (GroupVersionForDiscoveryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

