/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_3.handlers;

import io.fabric8.kubernetes.clnt.v4_3.Config;
import io.fabric8.kubernetes.clnt.v4_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_3.Watch;
import io.fabric8.kubernetes.clnt.v4_3.Watcher;
import io.fabric8.kubernetes.clnt.v4_3.dsl.Gettable;
import io.fabric8.openshift.api.model.v4_3.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_3.DeploymentConfigBuilder;
import io.fabric8.openshift.clnt.v4_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_3.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v4_3.dsl.internal.DeploymentConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DeploymentConfigHandler
implements ResourceHandler<DeploymentConfig, DeploymentConfigBuilder> {
    @Override
    public String getKind() {
        return DeploymentConfig.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public DeploymentConfig create(OkHttpClient client, Config config, String namespace, DeploymentConfig item) {
        return (DeploymentConfig)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new DeploymentConfig[0]);
    }

    @Override
    public DeploymentConfig replace(OkHttpClient client, Config config, String namespace, DeploymentConfig item) {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public DeploymentConfig reload(OkHttpClient client, Config config, String namespace, DeploymentConfig item) {
        return (DeploymentConfig)((Gettable)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public DeploymentConfigBuilder edit(DeploymentConfig item) {
        return new DeploymentConfigBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, DeploymentConfig item) {
        if (cascading.booleanValue()) {
            return (Boolean)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, Watcher<DeploymentConfig> watcher) {
        return (Watch)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, String resourceVersion, Watcher<DeploymentConfig> watcher) {
        return (Watch)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public DeploymentConfig waitUntilReady(OkHttpClient client, Config config, String namespace, DeploymentConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public DeploymentConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, DeploymentConfig item, Predicate<DeploymentConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

