/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_3.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_3.Doneable;
import io.fabric8.kubernetes.api.model.v4_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_3.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_3.Config;
import io.fabric8.kubernetes.clnt.v4_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_3.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_3.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_3.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v4_3.utils.Utils;
import io.fabric8.openshift.clnt.v4_3.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v4_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_3.OpenShiftConfigBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    public OpenShiftOperation(OperationContext ctx) {
        super(OpenShiftOperation.wrap(ctx));
    }

    public static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        DefaultOpenShiftClient oc = new DefaultOpenShiftClient(context.getClient(), config);
        if (Utils.isNotNullOrEmpty(context.getApiGroupName()) && config.isOpenShiftAPIGroups(oc)) {
            String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", context.getApiGroupName(), oapiVersion);
            String apiGroupVersion = URLUtils.join(context.getApiGroupName(), oapiVersion);
            return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
        }
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(oapiVersion);
    }

    @Override
    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

