/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_3.Nested;
import io.fabric8.kubernetes.api.builder.v4_3.Predicate;
import io.fabric8.kubernetes.api.model.v4_3.EnvVar;
import io.fabric8.kubernetes.api.model.v4_3.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v4_3.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_3.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_3.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_3.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_3.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v4_3.SourceBuildStrategy;
import io.fabric8.openshift.api.model.v4_3.SourceBuildStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>>
extends BaseFluent<A>
implements SourceBuildStrategyFluent<A> {
    private List<EnvVarBuilder> env;
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private Boolean incremental;
    private LocalObjectReferenceBuilder pullSecret;
    private String scripts;

    public SourceBuildStrategyFluentImpl() {
    }

    public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance) {
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withIncremental(instance.getIncremental());
        this.withPullSecret(instance.getPullSecret());
        this.withScripts(instance.getScripts());
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.get("env").add(index >= 0 ? index : this._visitables.get("env").size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get("env").size()) {
            this._visitables.get("env").add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return SourceBuildStrategyFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return SourceBuildStrategyFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<EnvVarBuilder>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public Boolean isForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    public A withNewForcePull(String arg1) {
        return this.withForcePull(new Boolean(arg1));
    }

    @Override
    public A withNewForcePull(boolean arg1) {
        return this.withForcePull(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public Boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public A withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return (A)this;
    }

    @Override
    public Boolean hasIncremental() {
        return this.incremental != null;
    }

    @Override
    public A withNewIncremental(String arg1) {
        return this.withIncremental(new Boolean(arg1));
    }

    @Override
    public A withNewIncremental(boolean arg1) {
        return this.withIncremental(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get("pullSecret").add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    @Override
    public String getScripts() {
        return this.scripts;
    }

    @Override
    public A withScripts(String scripts) {
        this.scripts = scripts;
        return (A)this;
    }

    @Override
    public Boolean hasScripts() {
        return this.scripts != null;
    }

    @Override
    public A withNewScripts(String arg1) {
        return this.withScripts(new String(arg1));
    }

    @Override
    public A withNewScripts(StringBuilder arg1) {
        return this.withScripts(new String(arg1));
    }

    @Override
    public A withNewScripts(StringBuffer arg1) {
        return this.withScripts(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.incremental != null ? !this.incremental.equals(that.incremental) : that.incremental != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        return !(this.scripts != null ? !this.scripts.equals(that.scripts) : that.scripts != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SourceBuildStrategyFluent.PullSecretNested<N>>
    implements SourceBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.FromNested<N>>
    implements SourceBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<SourceBuildStrategyFluent.EnvNested<N>>
    implements SourceBuildStrategyFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

