/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_3.Nested;
import io.fabric8.kubernetes.api.builder.v4_3.Predicate;
import io.fabric8.openshift.api.model.v4_3.RouteIngress;
import io.fabric8.openshift.api.model.v4_3.RouteIngressBuilder;
import io.fabric8.openshift.api.model.v4_3.RouteIngressFluentImpl;
import io.fabric8.openshift.api.model.v4_3.RouteStatus;
import io.fabric8.openshift.api.model.v4_3.RouteStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>>
extends BaseFluent<A>
implements RouteStatusFluent<A> {
    private List<RouteIngressBuilder> ingress;

    public RouteStatusFluentImpl() {
    }

    public RouteStatusFluentImpl(RouteStatus instance) {
        this.withIngress(instance.getIngress());
    }

    @Override
    public A addToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        this._visitables.get("ingress").add(index >= 0 ? index : this._visitables.get("ingress").size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        if (index < 0 || index >= this._visitables.get("ingress").size()) {
            this._visitables.get("ingress").add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(RouteIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<RouteIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(RouteIngress ... items) {
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<RouteIngress> items) {
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteIngress> getIngress() {
        return RouteStatusFluentImpl.build(this.ingress);
    }

    @Override
    public List<RouteIngress> buildIngress() {
        return RouteStatusFluentImpl.build(this.ingress);
    }

    @Override
    public RouteIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public RouteIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public RouteIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public RouteIngress buildMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<RouteIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withIngress(RouteIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public RouteStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public RouteStatusFluent.IngressNested<A> setNewIngressLike(int index, RouteIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply(this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusFluentImpl that = (RouteStatusFluentImpl)o;
        return !(this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null);
    }

    public class IngressNestedImpl<N>
    extends RouteIngressFluentImpl<RouteStatusFluent.IngressNested<N>>
    implements RouteStatusFluent.IngressNested<N>,
    Nested<N> {
        private final RouteIngressBuilder builder;
        private final int index;

        IngressNestedImpl(int index, RouteIngress item) {
            this.index = index;
            this.builder = new RouteIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new RouteIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

