/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_3.Route;
import io.fabric8.openshift.api.model.v4_3.RouteFluent;
import io.fabric8.openshift.api.model.v4_3.RouteFluentImpl;
import javax.validation.Validator;

public class RouteBuilder
extends RouteFluentImpl<RouteBuilder>
implements VisitableBuilder<Route, RouteBuilder> {
    RouteFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RouteBuilder() {
        this(true);
    }

    public RouteBuilder(Boolean validationEnabled) {
        this(new Route(), validationEnabled);
    }

    public RouteBuilder(RouteFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteBuilder(RouteFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Route(), validationEnabled);
    }

    public RouteBuilder(RouteFluent<?> fluent, Route instance) {
        this(fluent, instance, true);
    }

    public RouteBuilder(RouteFluent<?> fluent, Route instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public RouteBuilder(Route instance) {
        this(instance, (Boolean)true);
    }

    public RouteBuilder(Route instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public RouteBuilder(Validator validator) {
        this(new Route(), (Boolean)true);
    }

    public RouteBuilder(RouteFluent<?> fluent, Route instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RouteBuilder(Route instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Route build() {
        Route buildable = new Route(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteBuilder that = (RouteBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

