/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_3.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceCompare {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static TypeReference<HashMap<String, Object>> TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
    private static final String METADATA = "metadata";
    private static final String STATUS = "status";
    private static final String LABELS = "labels";

    public static <T> boolean equals(T left, T right) {
        HashMap<String, Object> rightMap;
        Map leftJson = (Map)JSON_MAPPER.convertValue(left, TYPE_REF);
        Map rightJson = (Map)JSON_MAPPER.convertValue(right, TYPE_REF);
        Map<String, Object> leftLabels = ResourceCompare.fetchLabels(leftJson);
        Map<String, Object> rightLabels = ResourceCompare.fetchLabels(rightJson);
        HashMap<String, Object> leftMap = ResourceCompare.trim(leftJson);
        return leftMap.equals(rightMap = ResourceCompare.trim(rightJson)) && leftLabels.equals(rightLabels);
    }

    private static HashMap<String, Object> trim(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        result.remove(STATUS);
        result.remove(METADATA);
        return result;
    }

    private static Map<String, Object> fetchLabels(Map<String, Object> map) {
        if (!map.containsKey(METADATA) || !((Map)map.get(METADATA)).containsKey(LABELS)) {
            return Collections.emptyMap();
        }
        return (Map)((Map)map.get(METADATA)).get(LABELS);
    }
}

