/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_3.handlers;

import io.fabric8.kubernetes.api.model.v4_3.Node;
import io.fabric8.kubernetes.api.model.v4_3.NodeBuilder;
import io.fabric8.kubernetes.clnt.v4_3.Config;
import io.fabric8.kubernetes.clnt.v4_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_3.Watch;
import io.fabric8.kubernetes.clnt.v4_3.Watcher;
import io.fabric8.kubernetes.clnt.v4_3.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_3.dsl.internal.NodeOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NodeHandler
implements ResourceHandler<Node, NodeBuilder> {
    @Override
    public String getKind() {
        return Node.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Node create(OkHttpClient client, Config config, String namespace, Node item) {
        return (Node)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Node[0]);
    }

    @Override
    public Node replace(OkHttpClient client, Config config, String namespace, Node item) {
        return (Node)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Node reload(OkHttpClient client, Config config, String namespace, Node item) {
        return (Node)((Gettable)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NodeBuilder edit(Node item) {
        return new NodeBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Node item) {
        if (cascading.booleanValue()) {
            return (Boolean)new NodeOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
        }
        return (Boolean)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Node item, Watcher<Node> watcher) {
        return (Watch)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Node item, String resourceVersion, Watcher<Node> watcher) {
        return (Watch)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Node waitUntilReady(OkHttpClient client, Config config, String namespace, Node item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Node)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Node waitUntilCondition(OkHttpClient client, Config config, String namespace, Node item, Predicate<Node> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Node)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

