/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_3.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_3.Doneable;
import io.fabric8.kubernetes.api.model.v4_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_3.KubernetesResource;
import io.fabric8.kubernetes.api.model.v4_3.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_3.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_3.Config;
import io.fabric8.kubernetes.clnt.v4_3.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_3.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_3.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_3.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v4_3.internal.KubernetesDeserializer;
import okhttp3.OkHttpClient;

public class CustomResourceOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>>
extends HasMetadataOperation<T, L, D, Resource<T, D>>
implements MixedOperation<T, L, D, Resource<T, D>> {
    private final boolean resourceNamespaced;

    public CustomResourceOperationsImpl(OkHttpClient client, Config config) {
        this(new CustomResourceOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public CustomResourceOperationsImpl(CustomResourceOperationContext context) {
        super(context.withApiGroupName(CustomResourceOperationsImpl.apiGroup((CustomResourceDefinition)context.getCrd())).withApiGroupVersion(CustomResourceOperationsImpl.apiVersion((CustomResourceDefinition)context.getCrd())).withPlural(CustomResourceOperationsImpl.resourceT((CustomResourceDefinition)context.getCrd())));
        this.type = context.getType();
        this.listType = context.getListType();
        this.doneableType = context.getDoneableType();
        this.resourceNamespaced = CustomResourceOperationsImpl.resourceNamespaced((CustomResourceDefinition)context.getCrd());
        this.apiVersion = this.getAPIGroup() + "/" + this.getAPIVersion();
        KubernetesDeserializer.registerCustomKind(this.type.getSimpleName(), this.type);
        if (KubernetesResource.class.isAssignableFrom(this.listType)) {
            KubernetesDeserializer.registerCustomKind(this.listType.getSimpleName(), this.listType);
        }
    }

    public CustomResourceOperationsImpl newInstance(OperationContext context) {
        return new CustomResourceOperationsImpl<T, L, D>((CustomResourceOperationContext)context);
    }

    protected static String apiGroup(CustomResourceDefinition crd) {
        return crd.getSpec().getGroup();
    }

    protected static String apiVersion(CustomResourceDefinition crd) {
        return crd.getSpec().getVersion();
    }

    protected static String resourceT(CustomResourceDefinition crd) {
        return crd.getSpec().getNames().getPlural();
    }

    protected static String name(CustomResourceDefinition crd) {
        return crd.getMetadata().getName();
    }

    protected static boolean resourceNamespaced(CustomResourceDefinition crd) {
        return "Namespaced".equals(crd.getSpec().getScope());
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.resourceNamespaced;
    }
}

