/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_3.dsl.base;

import io.fabric8.kubernetes.api.builder.v4_3.Function;
import io.fabric8.kubernetes.api.model.v4_3.Doneable;
import io.fabric8.kubernetes.api.model.v4_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_3.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_3.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v4_3.Watch;
import io.fabric8.kubernetes.clnt.v4_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_3.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v4_3.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_3.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v4_3.internal.readiness.ReadinessWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends BaseOperation<T, L, D, R> {
    public HasMetadataOperation(OperationContext ctx) {
        super(ctx);
    }

    @Override
    public D edit() throws KubernetesClientException {
        Function<HasMetadata, HasMetadata> visitor = resource -> {
            try {
                if (this.isCascading().booleanValue() && !this.isReaping() && this.reaper != null) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                return this.patch((T)resource);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("edit"), (Throwable)e);
            }
        };
        try {
            HasMetadata item = (HasMetadata)this.getMandatory();
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("edit"), (Throwable)e);
        }
    }

    @Override
    public T replace(T item) {
        String fixedResourceVersion = this.getResourceVersion();
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else {
                    HasMetadata got = (HasMetadata)this.get();
                    if (got == null) {
                        return null;
                    }
                    resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                }
                Function<HasMetadata, HasMetadata> visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handleReplace(resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)e);
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)caught);
    }

    @Override
    public T patch(T item) {
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if ((got = (HasMetadata)this.get()) == null) {
                    return null;
                }
                Function<HasMetadata, HasMetadata> visitor = resource -> {
                    try {
                        return this.handlePatch(got, resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)e);
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)caught);
    }

    protected T periodicWatchUntilReady(int i, long started, long interval, long amount) {
        HasMetadata item = (HasMetadata)this.fromServer().get();
        if (Readiness.isReady(item)) {
            return (T)item;
        }
        ReadinessWatcher<HasMetadata> watcher = new ReadinessWatcher<HasMetadata>(item);
        Throwable throwable = null;
        try (Watch watch = this.watch(item.getMetadata().getResourceVersion(), watcher);){
            HasMetadata hasMetadata = watcher.await(interval, TimeUnit.NANOSECONDS);
            return (T)hasMetadata;
        }
        catch (KubernetesClientTimeoutException e) {
            if (i <= 0) {
                throw e;
            }
            long remaining = started + amount - System.nanoTime();
            long next = Math.max(0L, Math.min(remaining, interval));
            T t = this.periodicWatchUntilReady(i - 1, started, next, amount);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public T waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        if (Readiness.isReadinessApplicable(this.getType())) {
            long started = System.nanoTime();
            this.waitUntilExists(amount, timeUnit);
            long alreadySpent = System.nanoTime() - started;
            long remaining = timeUnit.toNanos(amount) - alreadySpent;
            if (remaining <= 0L) {
                return this.periodicWatchUntilReady(0, System.nanoTime(), 0L, 0L);
            }
            return this.periodicWatchUntilReady(10, System.nanoTime(), Math.max(remaining / 10L, 1000000000L), remaining);
        }
        return (T)((HasMetadata)super.waitUntilReady(amount, timeUnit));
    }
}

