/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_3;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class VersionInfo {
    private Map<String, String> data;
    private Date buildDate;
    private String gitCommit;
    private String gitVersion;
    private String major;
    private String minor;
    private String gitTreeState;
    private String platform;
    private String goVersion;
    private String compiler;

    public Date getBuildDate() {
        return this.buildDate;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGitVersion() {
        return this.gitVersion;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getGitTreeState() {
        return this.gitTreeState;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getGoVersion() {
        return this.goVersion;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public VersionInfo(Map<String, String> jsonData) throws ParseException {
        this.data = jsonData;
        this.buildDate = new SimpleDateFormat("YYYY-MM-dd'T'HH:mm:ss'Z'").parse(jsonData.get("buildDate"));
        this.gitCommit = jsonData.get("gitCommit");
        this.gitVersion = jsonData.get("gitVersion");
        this.major = jsonData.get("major");
        this.minor = jsonData.get("minor");
        this.gitTreeState = jsonData.get("gitTreeState");
        this.platform = jsonData.get("platform");
        this.goVersion = jsonData.get("goVersion");
        this.compiler = jsonData.get("compiler");
    }

    public Map<String, String> getData() {
        return this.data;
    }

    private final class VERSION_KEYS {
        public static final String BUILD_DATE = "buildDate";
        public static final String GIT_COMMIT = "gitCommit";
        public static final String GIT_VERSION = "gitVersion";
        public static final String MAJOR = "major";
        public static final String MINOR = "minor";
        public static final String GIT_TREE_STATE = "gitTreeState";
        public static final String PLATFORM = "platform";
        public static final String GO_VERSION = "goVersion";
        public static final String COMPILER = "compiler";
        public static final String BUILD_DATE_FORMAT = "YYYY-MM-dd'T'HH:mm:ss'Z'";

        private VERSION_KEYS() {
        }
    }
}

