/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.settings;

import io.fabric8.kubernetes.api.builder.v4_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_3.Nested;
import io.fabric8.kubernetes.api.builder.v4_3.Predicate;
import io.fabric8.kubernetes.api.model.v4_3.EnvFromSource;
import io.fabric8.kubernetes.api.model.v4_3.EnvFromSourceBuilder;
import io.fabric8.kubernetes.api.model.v4_3.EnvFromSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.EnvVar;
import io.fabric8.kubernetes.api.model.v4_3.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v4_3.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_3.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v4_3.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.Volume;
import io.fabric8.kubernetes.api.model.v4_3.VolumeBuilder;
import io.fabric8.kubernetes.api.model.v4_3.VolumeFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.VolumeMount;
import io.fabric8.kubernetes.api.model.v4_3.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.v4_3.VolumeMountFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.settings.PodPresetSpec;
import io.fabric8.kubernetes.api.model.v4_3.settings.PodPresetSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodPresetSpecFluentImpl<A extends PodPresetSpecFluent<A>>
extends BaseFluent<A>
implements PodPresetSpecFluent<A> {
    private List<EnvVarBuilder> env;
    private List<EnvFromSourceBuilder> envFrom;
    private LabelSelectorBuilder selector;
    private List<VolumeMountBuilder> volumeMounts;
    private List<VolumeBuilder> volumes;

    public PodPresetSpecFluentImpl() {
    }

    public PodPresetSpecFluentImpl(PodPresetSpec instance) {
        this.withEnv(instance.getEnv());
        this.withEnvFrom(instance.getEnvFrom());
        this.withSelector(instance.getSelector());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.get("env").add(index >= 0 ? index : this._visitables.get("env").size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get("env").size()) {
            this._visitables.get("env").add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return PodPresetSpecFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return PodPresetSpecFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<EnvVarBuilder>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public PodPresetSpecFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public A addToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        this._visitables.get("envFrom").add(index >= 0 ? index : this._visitables.get("envFrom").size(), builder);
        this.envFrom.add(index >= 0 ? index : this.envFrom.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("envFrom").size()) {
            this._visitables.get("envFrom").add(builder);
        } else {
            this._visitables.get("envFrom").set(index, builder);
        }
        if (index < 0 || index >= this.envFrom.size()) {
            this.envFrom.add(builder);
        } else {
            this.envFrom.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvFrom(EnvFromSource ... items) {
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            if (this.envFrom == null) continue;
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            if (this.envFrom == null) continue;
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvFromSource> getEnvFrom() {
        return PodPresetSpecFluentImpl.build(this.envFrom);
    }

    @Override
    public List<EnvFromSource> buildEnvFrom() {
        return PodPresetSpecFluentImpl.build(this.envFrom);
    }

    @Override
    public EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    @Override
    public EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    @Override
    public EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1).build();
    }

    @Override
    public EnvFromSource buildMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get("envFrom").removeAll(this.envFrom);
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withEnvFrom(EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
        }
        if (envFrom != null) {
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNestedImpl();
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> addNewEnvFromLike(EnvFromSource item) {
        return new EnvFromNestedImpl(-1, item);
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> setNewEnvFromLike(int index, EnvFromSource item) {
        return new EnvFromNestedImpl(index, item);
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> editEnvFrom(int index) {
        if (this.envFrom.size() <= index) {
            throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> editFirstEnvFrom() {
        if (this.envFrom.size() == 0) {
            throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(0, this.buildEnvFrom(0));
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> editLastEnvFrom() {
        int index = this.envFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public PodPresetSpecFluent.EnvFromNested<A> editMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envFrom.size(); ++i) {
            if (!predicate.apply(this.envFrom.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envFrom. No match found.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PodPresetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PodPresetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PodPresetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodPresetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodPresetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        this._visitables.get("volumeMounts").add(index >= 0 ? index : this._visitables.get("volumeMounts").size(), builder);
        this.volumeMounts.add(index >= 0 ? index : this.volumeMounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeMounts").size()) {
            this._visitables.get("volumeMounts").add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
        }
        if (index < 0 || index >= this.volumeMounts.size()) {
            this.volumeMounts.add(builder);
        } else {
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeMount> getVolumeMounts() {
        return PodPresetSpecFluentImpl.build(this.volumeMounts);
    }

    @Override
    public List<VolumeMount> buildVolumeMounts() {
        return PodPresetSpecFluentImpl.build(this.volumeMounts);
    }

    @Override
    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    @Override
    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    @Override
    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    @Override
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").removeAll(this.volumeMounts);
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public PodPresetSpecFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.apply(this.volumeMounts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get("volumes").add(index >= 0 ? index : this._visitables.get("volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumes").size()) {
            this._visitables.get("volumes").add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return PodPresetSpecFluentImpl.build(this.volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return PodPresetSpecFluentImpl.build(this.volumes);
    }

    @Override
    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<VolumeBuilder>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodPresetSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.apply(this.volumes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodPresetSpecFluentImpl that = (PodPresetSpecFluentImpl)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.envFrom != null ? !this.envFrom.equals(that.envFrom) : that.envFrom != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<PodPresetSpecFluent.VolumesNested<N>>
    implements PodPresetSpecFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodPresetSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class VolumeMountsNestedImpl<N>
    extends VolumeMountFluentImpl<PodPresetSpecFluent.VolumeMountsNested<N>>
    implements PodPresetSpecFluent.VolumeMountsNested<N>,
    Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

        VolumeMountsNestedImpl(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new VolumeMountBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodPresetSpecFluentImpl.this.setToVolumeMounts(this.index, this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodPresetSpecFluent.SelectorNested<N>>
    implements PodPresetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodPresetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class EnvFromNestedImpl<N>
    extends EnvFromSourceFluentImpl<PodPresetSpecFluent.EnvFromNested<N>>
    implements PodPresetSpecFluent.EnvFromNested<N>,
    Nested<N> {
        private final EnvFromSourceBuilder builder;
        private final int index;

        EnvFromNestedImpl(int index, EnvFromSource item) {
            this.index = index;
            this.builder = new EnvFromSourceBuilder(this, item);
        }

        EnvFromNestedImpl() {
            this.index = -1;
            this.builder = new EnvFromSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodPresetSpecFluentImpl.this.setToEnvFrom(this.index, this.builder.build());
        }

        @Override
        public N endEnvFrom() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<PodPresetSpecFluent.EnvNested<N>>
    implements PodPresetSpecFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodPresetSpecFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

