/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.rbac;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.rbac.ClusterRoleBindingList;
import io.fabric8.kubernetes.api.model.v4_3.rbac.ClusterRoleBindingListFluent;
import io.fabric8.kubernetes.api.model.v4_3.rbac.ClusterRoleBindingListFluentImpl;
import javax.validation.Validator;

public class ClusterRoleBindingListBuilder
extends ClusterRoleBindingListFluentImpl<ClusterRoleBindingListBuilder>
implements VisitableBuilder<ClusterRoleBindingList, ClusterRoleBindingListBuilder> {
    ClusterRoleBindingListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterRoleBindingListBuilder() {
        this(true);
    }

    public ClusterRoleBindingListBuilder(Boolean validationEnabled) {
        this(new ClusterRoleBindingList(), validationEnabled);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterRoleBindingList(), validationEnabled);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, ClusterRoleBindingList instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, ClusterRoleBindingList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance) {
        this(instance, (Boolean)true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBindingListBuilder(Validator validator) {
        this(new ClusterRoleBindingList(), (Boolean)true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, ClusterRoleBindingList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ClusterRoleBindingList build() {
        ClusterRoleBindingList buildable = new ClusterRoleBindingList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBindingListBuilder that = (ClusterRoleBindingListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

