/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.rbac;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.rbac.AggregationRule;
import io.fabric8.kubernetes.api.model.v4_3.rbac.AggregationRuleFluent;
import io.fabric8.kubernetes.api.model.v4_3.rbac.AggregationRuleFluentImpl;
import javax.validation.Validator;

public class AggregationRuleBuilder
extends AggregationRuleFluentImpl<AggregationRuleBuilder>
implements VisitableBuilder<AggregationRule, AggregationRuleBuilder> {
    AggregationRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AggregationRuleBuilder() {
        this(true);
    }

    public AggregationRuleBuilder(Boolean validationEnabled) {
        this(new AggregationRule(), validationEnabled);
    }

    public AggregationRuleBuilder(AggregationRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AggregationRuleBuilder(AggregationRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AggregationRule(), validationEnabled);
    }

    public AggregationRuleBuilder(AggregationRuleFluent<?> fluent, AggregationRule instance) {
        this(fluent, instance, true);
    }

    public AggregationRuleBuilder(AggregationRuleFluent<?> fluent, AggregationRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validationEnabled = validationEnabled;
    }

    public AggregationRuleBuilder(AggregationRule instance) {
        this(instance, (Boolean)true);
    }

    public AggregationRuleBuilder(AggregationRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validationEnabled = validationEnabled;
    }

    public AggregationRuleBuilder(Validator validator) {
        this(new AggregationRule(), (Boolean)true);
    }

    public AggregationRuleBuilder(AggregationRuleFluent<?> fluent, AggregationRule instance, Validator validator) {
        this.fluent = fluent;
        fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AggregationRuleBuilder(AggregationRule instance, Validator validator) {
        this.fluent = this;
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public AggregationRule build() {
        AggregationRule buildable = new AggregationRule(this.fluent.getClusterRoleSelectors());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationRuleBuilder that = (AggregationRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

