/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.extensions;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.extensions.Ingress;
import io.fabric8.kubernetes.api.model.v4_3.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.v4_3.extensions.IngressFluentImpl;
import javax.validation.Validator;

public class IngressBuilder
extends IngressFluentImpl<IngressBuilder>
implements VisitableBuilder<Ingress, IngressBuilder> {
    IngressFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressBuilder() {
        this(true);
    }

    public IngressBuilder(Boolean validationEnabled) {
        this(new Ingress(), validationEnabled);
    }

    public IngressBuilder(IngressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressBuilder(IngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Ingress(), validationEnabled);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance) {
        this(fluent, instance, true);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public IngressBuilder(Ingress instance) {
        this(instance, (Boolean)true);
    }

    public IngressBuilder(Ingress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public IngressBuilder(Validator validator) {
        this(new Ingress(), (Boolean)true);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressBuilder(Ingress instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Ingress build() {
        Ingress buildable = new Ingress(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBuilder that = (IngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

