/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.authentication;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v4_3.authentication.TokenReviewFluent;
import io.fabric8.kubernetes.api.model.v4_3.authentication.TokenReviewFluentImpl;
import javax.validation.Validator;

public class TokenReviewBuilder
extends TokenReviewFluentImpl<TokenReviewBuilder>
implements VisitableBuilder<TokenReview, TokenReviewBuilder> {
    TokenReviewFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TokenReviewBuilder() {
        this(true);
    }

    public TokenReviewBuilder(Boolean validationEnabled) {
        this(new TokenReview(), validationEnabled);
    }

    public TokenReviewBuilder(TokenReviewFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TokenReviewBuilder(TokenReviewFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenReview(), validationEnabled);
    }

    public TokenReviewBuilder(TokenReviewFluent<?> fluent, TokenReview instance) {
        this(fluent, instance, true);
    }

    public TokenReviewBuilder(TokenReviewFluent<?> fluent, TokenReview instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public TokenReviewBuilder(TokenReview instance) {
        this(instance, (Boolean)true);
    }

    public TokenReviewBuilder(TokenReview instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public TokenReviewBuilder(Validator validator) {
        this(new TokenReview(), (Boolean)true);
    }

    public TokenReviewBuilder(TokenReviewFluent<?> fluent, TokenReview instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TokenReviewBuilder(TokenReview instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public TokenReview build() {
        TokenReview buildable = new TokenReview(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewBuilder that = (TokenReviewBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

