/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.apps;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.v4_3.apps.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.v4_3.apps.DaemonSetSpecFluentImpl;
import javax.validation.Validator;

public class DaemonSetSpecBuilder
extends DaemonSetSpecFluentImpl<DaemonSetSpecBuilder>
implements VisitableBuilder<DaemonSetSpec, DaemonSetSpecBuilder> {
    DaemonSetSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DaemonSetSpecBuilder() {
        this(true);
    }

    public DaemonSetSpecBuilder(Boolean validationEnabled) {
        this(new DaemonSetSpec(), validationEnabled);
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DaemonSetSpec(), validationEnabled);
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent, DaemonSetSpec instance) {
        this(fluent, instance, true);
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent, DaemonSetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        fluent.withUpdateStrategy(instance.getUpdateStrategy());
        this.validationEnabled = validationEnabled;
    }

    public DaemonSetSpecBuilder(DaemonSetSpec instance) {
        this(instance, (Boolean)true);
    }

    public DaemonSetSpecBuilder(DaemonSetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.validationEnabled = validationEnabled;
    }

    public DaemonSetSpecBuilder(Validator validator) {
        this(new DaemonSetSpec(), (Boolean)true);
    }

    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent, DaemonSetSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        fluent.withUpdateStrategy(instance.getUpdateStrategy());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DaemonSetSpecBuilder(DaemonSetSpec instance, Validator validator) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public DaemonSetSpec build() {
        DaemonSetSpec buildable = new DaemonSetSpec(this.fluent.getMinReadySeconds(), this.fluent.getRevisionHistoryLimit(), this.fluent.getSelector(), this.fluent.getTemplate(), this.fluent.getUpdateStrategy());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetSpecBuilder that = (DaemonSetSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

