/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.apiextensions;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.apiextensions.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.v4_3.apiextensions.CustomResourceConversionFluent;
import io.fabric8.kubernetes.api.model.v4_3.apiextensions.CustomResourceConversionFluentImpl;
import javax.validation.Validator;

public class CustomResourceConversionBuilder
extends CustomResourceConversionFluentImpl<CustomResourceConversionBuilder>
implements VisitableBuilder<CustomResourceConversion, CustomResourceConversionBuilder> {
    CustomResourceConversionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CustomResourceConversionBuilder() {
        this(true);
    }

    public CustomResourceConversionBuilder(Boolean validationEnabled) {
        this(new CustomResourceConversion(), validationEnabled);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceConversion(), validationEnabled);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, CustomResourceConversion instance) {
        this(fluent, instance, true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, CustomResourceConversion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStrategy(instance.getStrategy());
        fluent.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceConversionBuilder(CustomResourceConversion instance) {
        this(instance, (Boolean)true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceConversionBuilder(Validator validator) {
        this(new CustomResourceConversion(), (Boolean)true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, CustomResourceConversion instance, Validator validator) {
        this.fluent = fluent;
        fluent.withStrategy(instance.getStrategy());
        fluent.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CustomResourceConversionBuilder(CustomResourceConversion instance, Validator validator) {
        this.fluent = this;
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CustomResourceConversion build() {
        CustomResourceConversion buildable = new CustomResourceConversion(this.fluent.getStrategy(), this.fluent.getWebhookClientConfig());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceConversionBuilder that = (CustomResourceConversionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

