/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3.admission;

import io.fabric8.kubernetes.api.builder.v4_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_3.Nested;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionRequest;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionRequestBuilder;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionRequestFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionResponse;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionResponseBuilder;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionResponseFluentImpl;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionReview;
import io.fabric8.kubernetes.api.model.v4_3.admission.AdmissionReviewFluent;

public class AdmissionReviewFluentImpl<A extends AdmissionReviewFluent<A>>
extends BaseFluent<A>
implements AdmissionReviewFluent<A> {
    private String apiVersion;
    private String kind;
    private AdmissionRequestBuilder request;
    private AdmissionResponseBuilder response;

    public AdmissionReviewFluentImpl() {
    }

    public AdmissionReviewFluentImpl(AdmissionReview instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public AdmissionRequest getRequest() {
        return this.request != null ? this.request.build() : null;
    }

    @Override
    public AdmissionRequest buildRequest() {
        return this.request != null ? this.request.build() : null;
    }

    @Override
    public A withRequest(AdmissionRequest request) {
        this._visitables.get("request").remove(this.request);
        if (request != null) {
            this.request = new AdmissionRequestBuilder(request);
            this._visitables.get("request").add(this.request);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null;
    }

    @Override
    public AdmissionReviewFluent.RequestNested<A> withNewRequest() {
        return new RequestNestedImpl();
    }

    @Override
    public AdmissionReviewFluent.RequestNested<A> withNewRequestLike(AdmissionRequest item) {
        return new RequestNestedImpl(item);
    }

    @Override
    public AdmissionReviewFluent.RequestNested<A> editRequest() {
        return this.withNewRequestLike(this.getRequest());
    }

    @Override
    public AdmissionReviewFluent.RequestNested<A> editOrNewRequest() {
        return this.withNewRequestLike(this.getRequest() != null ? this.getRequest() : new AdmissionRequestBuilder().build());
    }

    @Override
    public AdmissionReviewFluent.RequestNested<A> editOrNewRequestLike(AdmissionRequest item) {
        return this.withNewRequestLike(this.getRequest() != null ? this.getRequest() : item);
    }

    @Override
    @Deprecated
    public AdmissionResponse getResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public AdmissionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public A withResponse(AdmissionResponse response) {
        this._visitables.get("response").remove(this.response);
        if (response != null) {
            this.response = new AdmissionResponseBuilder(response);
            this._visitables.get("response").add(this.response);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> withNewResponse() {
        return new ResponseNestedImpl();
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
        return new ResponseNestedImpl(item);
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editResponse() {
        return this.withNewResponseLike(this.getResponse());
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : new AdmissionResponseBuilder().build());
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionReviewFluentImpl that = (AdmissionReviewFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public class ResponseNestedImpl<N>
    extends AdmissionResponseFluentImpl<AdmissionReviewFluent.ResponseNested<N>>
    implements AdmissionReviewFluent.ResponseNested<N>,
    Nested<N> {
        private final AdmissionResponseBuilder builder;

        ResponseNestedImpl(AdmissionResponse item) {
            this.builder = new AdmissionResponseBuilder(this, item);
        }

        ResponseNestedImpl() {
            this.builder = new AdmissionResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)AdmissionReviewFluentImpl.this.withResponse(this.builder.build());
        }

        @Override
        public N endResponse() {
            return this.and();
        }
    }

    public class RequestNestedImpl<N>
    extends AdmissionRequestFluentImpl<AdmissionReviewFluent.RequestNested<N>>
    implements AdmissionReviewFluent.RequestNested<N>,
    Nested<N> {
        private final AdmissionRequestBuilder builder;

        RequestNestedImpl(AdmissionRequest item) {
            this.builder = new AdmissionRequestBuilder(this, item);
        }

        RequestNestedImpl() {
            this.builder = new AdmissionRequestBuilder(this);
        }

        @Override
        public N and() {
            return (N)AdmissionReviewFluentImpl.this.withRequest(this.builder.build());
        }

        @Override
        public N endRequest() {
            return this.and();
        }
    }
}

