/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.ServiceList;
import io.fabric8.kubernetes.api.model.v4_3.ServiceListFluent;
import io.fabric8.kubernetes.api.model.v4_3.ServiceListFluentImpl;
import javax.validation.Validator;

public class ServiceListBuilder
extends ServiceListFluentImpl<ServiceListBuilder>
implements VisitableBuilder<ServiceList, ServiceListBuilder> {
    ServiceListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceListBuilder() {
        this(true);
    }

    public ServiceListBuilder(Boolean validationEnabled) {
        this(new ServiceList(), validationEnabled);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceList(), validationEnabled);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, ServiceList instance) {
        this(fluent, instance, true);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, ServiceList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ServiceListBuilder(ServiceList instance) {
        this(instance, (Boolean)true);
    }

    public ServiceListBuilder(ServiceList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ServiceListBuilder(Validator validator) {
        this(new ServiceList(), (Boolean)true);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, ServiceList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceListBuilder(ServiceList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceList build() {
        ServiceList buildable = new ServiceList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceListBuilder that = (ServiceListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

