/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.Preferences;
import io.fabric8.kubernetes.api.model.v4_3.PreferencesFluent;
import io.fabric8.kubernetes.api.model.v4_3.PreferencesFluentImpl;
import javax.validation.Validator;

public class PreferencesBuilder
extends PreferencesFluentImpl<PreferencesBuilder>
implements VisitableBuilder<Preferences, PreferencesBuilder> {
    PreferencesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PreferencesBuilder() {
        this(true);
    }

    public PreferencesBuilder(Boolean validationEnabled) {
        this(new Preferences(), validationEnabled);
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Preferences(), validationEnabled);
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent, Preferences instance) {
        this(fluent, instance, true);
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent, Preferences instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withColors(instance.getColors());
        fluent.withExtensions(instance.getExtensions());
        this.validationEnabled = validationEnabled;
    }

    public PreferencesBuilder(Preferences instance) {
        this(instance, (Boolean)true);
    }

    public PreferencesBuilder(Preferences instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withColors(instance.getColors());
        this.withExtensions(instance.getExtensions());
        this.validationEnabled = validationEnabled;
    }

    public PreferencesBuilder(Validator validator) {
        this(new Preferences(), (Boolean)true);
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent, Preferences instance, Validator validator) {
        this.fluent = fluent;
        fluent.withColors(instance.getColors());
        fluent.withExtensions(instance.getExtensions());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PreferencesBuilder(Preferences instance, Validator validator) {
        this.fluent = this;
        this.withColors(instance.getColors());
        this.withExtensions(instance.getExtensions());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Preferences build() {
        Preferences buildable = new Preferences(this.fluent.isColors(), this.fluent.getExtensions());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreferencesBuilder that = (PreferencesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

