/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.PodTemplate;
import io.fabric8.kubernetes.api.model.v4_3.PodTemplateFluent;
import io.fabric8.kubernetes.api.model.v4_3.PodTemplateFluentImpl;
import javax.validation.Validator;

public class PodTemplateBuilder
extends PodTemplateFluentImpl<PodTemplateBuilder>
implements VisitableBuilder<PodTemplate, PodTemplateBuilder> {
    PodTemplateFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodTemplateBuilder() {
        this(true);
    }

    public PodTemplateBuilder(Boolean validationEnabled) {
        this(new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, PodTemplate instance) {
        this(fluent, instance, true);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, PodTemplate instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public PodTemplateBuilder(PodTemplate instance) {
        this(instance, (Boolean)true);
    }

    public PodTemplateBuilder(PodTemplate instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public PodTemplateBuilder(Validator validator) {
        this(new PodTemplate(), (Boolean)true);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, PodTemplate instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withTemplate(instance.getTemplate());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodTemplateBuilder(PodTemplate instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTemplate(instance.getTemplate());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodTemplate build() {
        PodTemplate buildable = new PodTemplate(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getTemplate());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodTemplateBuilder that = (PodTemplateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

