/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.PodDNSConfig;
import io.fabric8.kubernetes.api.model.v4_3.PodDNSConfigFluent;
import io.fabric8.kubernetes.api.model.v4_3.PodDNSConfigFluentImpl;
import javax.validation.Validator;

public class PodDNSConfigBuilder
extends PodDNSConfigFluentImpl<PodDNSConfigBuilder>
implements VisitableBuilder<PodDNSConfig, PodDNSConfigBuilder> {
    PodDNSConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodDNSConfigBuilder() {
        this(true);
    }

    public PodDNSConfigBuilder(Boolean validationEnabled) {
        this(new PodDNSConfig(), validationEnabled);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodDNSConfig(), validationEnabled);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, PodDNSConfig instance) {
        this(fluent, instance, true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, PodDNSConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNameservers(instance.getNameservers());
        fluent.withOptions(instance.getOptions());
        fluent.withSearches(instance.getSearches());
        this.validationEnabled = validationEnabled;
    }

    public PodDNSConfigBuilder(PodDNSConfig instance) {
        this(instance, (Boolean)true);
    }

    public PodDNSConfigBuilder(PodDNSConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNameservers(instance.getNameservers());
        this.withOptions(instance.getOptions());
        this.withSearches(instance.getSearches());
        this.validationEnabled = validationEnabled;
    }

    public PodDNSConfigBuilder(Validator validator) {
        this(new PodDNSConfig(), (Boolean)true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, PodDNSConfig instance, Validator validator) {
        this.fluent = fluent;
        fluent.withNameservers(instance.getNameservers());
        fluent.withOptions(instance.getOptions());
        fluent.withSearches(instance.getSearches());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodDNSConfigBuilder(PodDNSConfig instance, Validator validator) {
        this.fluent = this;
        this.withNameservers(instance.getNameservers());
        this.withOptions(instance.getOptions());
        this.withSearches(instance.getSearches());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodDNSConfig build() {
        PodDNSConfig buildable = new PodDNSConfig(this.fluent.getNameservers(), this.fluent.getOptions(), this.fluent.getSearches());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodDNSConfigBuilder that = (PodDNSConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

