/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.NamedContext;
import io.fabric8.kubernetes.api.model.v4_3.NamedContextFluent;
import io.fabric8.kubernetes.api.model.v4_3.NamedContextFluentImpl;
import javax.validation.Validator;

public class NamedContextBuilder
extends NamedContextFluentImpl<NamedContextBuilder>
implements VisitableBuilder<NamedContext, NamedContextBuilder> {
    NamedContextFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamedContextBuilder() {
        this(true);
    }

    public NamedContextBuilder(Boolean validationEnabled) {
        this(new NamedContext(), validationEnabled);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedContext(), validationEnabled);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, NamedContext instance) {
        this(fluent, instance, true);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, NamedContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContext(instance.getContext());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public NamedContextBuilder(NamedContext instance) {
        this(instance, (Boolean)true);
    }

    public NamedContextBuilder(NamedContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContext(instance.getContext());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public NamedContextBuilder(Validator validator) {
        this(new NamedContext(), (Boolean)true);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, NamedContext instance, Validator validator) {
        this.fluent = fluent;
        fluent.withContext(instance.getContext());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NamedContextBuilder(NamedContext instance, Validator validator) {
        this.fluent = this;
        this.withContext(instance.getContext());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NamedContext build() {
        NamedContext buildable = new NamedContext(this.fluent.getContext(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedContextBuilder that = (NamedContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

