/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.EventList;
import io.fabric8.kubernetes.api.model.v4_3.EventListFluent;
import io.fabric8.kubernetes.api.model.v4_3.EventListFluentImpl;
import javax.validation.Validator;

public class EventListBuilder
extends EventListFluentImpl<EventListBuilder>
implements VisitableBuilder<EventList, EventListBuilder> {
    EventListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EventListBuilder() {
        this(true);
    }

    public EventListBuilder(Boolean validationEnabled) {
        this(new EventList(), validationEnabled);
    }

    public EventListBuilder(EventListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EventListBuilder(EventListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EventList(), validationEnabled);
    }

    public EventListBuilder(EventListFluent<?> fluent, EventList instance) {
        this(fluent, instance, true);
    }

    public EventListBuilder(EventListFluent<?> fluent, EventList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public EventListBuilder(EventList instance) {
        this(instance, (Boolean)true);
    }

    public EventListBuilder(EventList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public EventListBuilder(Validator validator) {
        this(new EventList(), (Boolean)true);
    }

    public EventListBuilder(EventListFluent<?> fluent, EventList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EventListBuilder(EventList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public EventList build() {
        EventList buildable = new EventList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListBuilder that = (EventListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

