/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.EndpointAddress;
import io.fabric8.kubernetes.api.model.v4_3.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.v4_3.EndpointAddressFluentImpl;
import javax.validation.Validator;

public class EndpointAddressBuilder
extends EndpointAddressFluentImpl<EndpointAddressBuilder>
implements VisitableBuilder<EndpointAddress, EndpointAddressBuilder> {
    EndpointAddressFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EndpointAddressBuilder() {
        this(true);
    }

    public EndpointAddressBuilder(Boolean validationEnabled) {
        this(new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance) {
        this(fluent, instance, true);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        fluent.withNodeName(instance.getNodeName());
        fluent.withTargetRef(instance.getTargetRef());
        this.validationEnabled = validationEnabled;
    }

    public EndpointAddressBuilder(EndpointAddress instance) {
        this(instance, (Boolean)true);
    }

    public EndpointAddressBuilder(EndpointAddress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
        this.validationEnabled = validationEnabled;
    }

    public EndpointAddressBuilder(Validator validator) {
        this(new EndpointAddress(), (Boolean)true);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        fluent.withNodeName(instance.getNodeName());
        fluent.withTargetRef(instance.getTargetRef());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EndpointAddressBuilder(EndpointAddress instance, Validator validator) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public EndpointAddress build() {
        EndpointAddress buildable = new EndpointAddress(this.fluent.getHostname(), this.fluent.getIp(), this.fluent.getNodeName(), this.fluent.getTargetRef());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressBuilder that = (EndpointAddressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

