/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.ConfigMapList;
import io.fabric8.kubernetes.api.model.v4_3.ConfigMapListFluent;
import io.fabric8.kubernetes.api.model.v4_3.ConfigMapListFluentImpl;
import javax.validation.Validator;

public class ConfigMapListBuilder
extends ConfigMapListFluentImpl<ConfigMapListBuilder>
implements VisitableBuilder<ConfigMapList, ConfigMapListBuilder> {
    ConfigMapListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ConfigMapListBuilder() {
        this(true);
    }

    public ConfigMapListBuilder(Boolean validationEnabled) {
        this(new ConfigMapList(), validationEnabled);
    }

    public ConfigMapListBuilder(ConfigMapListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigMapListBuilder(ConfigMapListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigMapList(), validationEnabled);
    }

    public ConfigMapListBuilder(ConfigMapListFluent<?> fluent, ConfigMapList instance) {
        this(fluent, instance, true);
    }

    public ConfigMapListBuilder(ConfigMapListFluent<?> fluent, ConfigMapList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapListBuilder(ConfigMapList instance) {
        this(instance, (Boolean)true);
    }

    public ConfigMapListBuilder(ConfigMapList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapListBuilder(Validator validator) {
        this(new ConfigMapList(), (Boolean)true);
    }

    public ConfigMapListBuilder(ConfigMapListFluent<?> fluent, ConfigMapList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ConfigMapListBuilder(ConfigMapList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ConfigMapList build() {
        ConfigMapList buildable = new ConfigMapList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapListBuilder that = (ConfigMapListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

