/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.Config;
import io.fabric8.kubernetes.api.model.v4_3.ConfigFluent;
import io.fabric8.kubernetes.api.model.v4_3.ConfigFluentImpl;
import javax.validation.Validator;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ConfigBuilder() {
        this(true);
    }

    public ConfigBuilder(Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this(fluent, instance, true);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClusters(instance.getClusters());
        fluent.withContexts(instance.getContexts());
        fluent.withCurrentContext(instance.getCurrentContext());
        fluent.withExtensions(instance.getExtensions());
        fluent.withKind(instance.getKind());
        fluent.withPreferences(instance.getPreferences());
        fluent.withUsers(instance.getUsers());
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Config instance) {
        this(instance, (Boolean)true);
    }

    public ConfigBuilder(Config instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Validator validator) {
        this(new Config(), (Boolean)true);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClusters(instance.getClusters());
        fluent.withContexts(instance.getContexts());
        fluent.withCurrentContext(instance.getCurrentContext());
        fluent.withExtensions(instance.getExtensions());
        fluent.withKind(instance.getKind());
        fluent.withPreferences(instance.getPreferences());
        fluent.withUsers(instance.getUsers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ConfigBuilder(Config instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Config build() {
        Config buildable = new Config(this.fluent.getApiVersion(), this.fluent.getClusters(), this.fluent.getContexts(), this.fluent.getCurrentContext(), this.fluent.getExtensions(), this.fluent.getKind(), this.fluent.getPreferences(), this.fluent.getUsers());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

