/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.ComponentStatus;
import io.fabric8.kubernetes.api.model.v4_3.ComponentStatusFluent;
import io.fabric8.kubernetes.api.model.v4_3.ComponentStatusFluentImpl;
import javax.validation.Validator;

public class ComponentStatusBuilder
extends ComponentStatusFluentImpl<ComponentStatusBuilder>
implements VisitableBuilder<ComponentStatus, ComponentStatusBuilder> {
    ComponentStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ComponentStatusBuilder() {
        this(true);
    }

    public ComponentStatusBuilder(Boolean validationEnabled) {
        this(new ComponentStatus(), validationEnabled);
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ComponentStatus(), validationEnabled);
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent, ComponentStatus instance) {
        this(fluent, instance, true);
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent, ComponentStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withConditions(instance.getConditions());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ComponentStatusBuilder(ComponentStatus instance) {
        this(instance, (Boolean)true);
    }

    public ComponentStatusBuilder(ComponentStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ComponentStatusBuilder(Validator validator) {
        this(new ComponentStatus(), (Boolean)true);
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent, ComponentStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withConditions(instance.getConditions());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ComponentStatusBuilder(ComponentStatus instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ComponentStatus build() {
        ComponentStatus buildable = new ComponentStatus(this.fluent.getApiVersion(), this.fluent.getConditions(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentStatusBuilder that = (ComponentStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

