/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.BaseKubernetesList;
import io.fabric8.kubernetes.api.model.v4_3.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.v4_3.BaseKubernetesListFluentImpl;
import javax.validation.Validator;

public class BaseKubernetesListBuilder
extends BaseKubernetesListFluentImpl<BaseKubernetesListBuilder>
implements VisitableBuilder<BaseKubernetesList, BaseKubernetesListBuilder> {
    BaseKubernetesListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BaseKubernetesListBuilder() {
        this(true);
    }

    public BaseKubernetesListBuilder(Boolean validationEnabled) {
        this(new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance) {
        this(fluent, instance, true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance) {
        this(instance, (Boolean)true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BaseKubernetesListBuilder(Validator validator) {
        this(new BaseKubernetesList(), (Boolean)true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BaseKubernetesList build() {
        BaseKubernetesList buildable = new BaseKubernetesList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseKubernetesListBuilder that = (BaseKubernetesListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

