/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.v4_3.AWSElasticBlockStoreVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v4_3.AWSElasticBlockStoreVolumeSourceFluentImpl;
import javax.validation.Validator;

public class AWSElasticBlockStoreVolumeSourceBuilder
extends AWSElasticBlockStoreVolumeSourceFluentImpl<AWSElasticBlockStoreVolumeSourceBuilder>
implements VisitableBuilder<AWSElasticBlockStoreVolumeSource, AWSElasticBlockStoreVolumeSourceBuilder> {
    AWSElasticBlockStoreVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AWSElasticBlockStoreVolumeSourceBuilder() {
        this(true);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(Boolean validationEnabled) {
        this(new AWSElasticBlockStoreVolumeSource(), validationEnabled);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AWSElasticBlockStoreVolumeSource(), validationEnabled);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent, AWSElasticBlockStoreVolumeSource instance) {
        this(fluent, instance, true);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent, AWSElasticBlockStoreVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withPartition(instance.getPartition());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withVolumeID(instance.getVolumeID());
        this.validationEnabled = validationEnabled;
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withPartition(instance.getPartition());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeID(instance.getVolumeID());
        this.validationEnabled = validationEnabled;
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(Validator validator) {
        this(new AWSElasticBlockStoreVolumeSource(), (Boolean)true);
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent, AWSElasticBlockStoreVolumeSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withPartition(instance.getPartition());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withVolumeID(instance.getVolumeID());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSource instance, Validator validator) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withPartition(instance.getPartition());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeID(instance.getVolumeID());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public AWSElasticBlockStoreVolumeSource build() {
        AWSElasticBlockStoreVolumeSource buildable = new AWSElasticBlockStoreVolumeSource(this.fluent.getFsType(), this.fluent.getPartition(), this.fluent.isReadOnly(), this.fluent.getVolumeID());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSElasticBlockStoreVolumeSourceBuilder that = (AWSElasticBlockStoreVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

